#!/bin/sh
#Create drupal from install
#Usage intstructions
if [ $# != 2 ]; then
  cat >&2 << EOH
$0 - Create drupal site from template database skeldb
Usage:
  $0 sitename skeldb

EOH
exit 1;
fi
site_name=$1
db_name=drupal$site_name
skeldb=$2
#Create an empty mysql database and grant permissions to drupal user
./createdb.sh $db_name
#Copy the database contents from a skeleton/template database
./copydb.sh $skeldb $db_name
#Set some site specific variables (e.g. files path /files/<sitename>
./update-variables.sh $db_name $site_name
#Create a directory to store images and files in
./createdrupalsite.sh $site_name $db_name
