#!/bin/sh
##
# @file createdb.sh
#
# Creates a a blank database and grants all access to it.
# @param dbName
#---------------------------------
. drupal-env.sh
#--------------------------
# Create a database for dupal and populate it.
if [ $# != 1 ]; then
  cat >&2 << EOH
$0 - Creates a drupal database

Usage:
  $0 dbname

EOH
#--------------------------
exit 1;
fi
mysql -u root << EOF
create database $1;
grant all privileges on $1.* to ${drupal_dbuser};
flush privileges;
\q
EOF