#!/bin/sh
#----------------
# Creates the drupal site settings for a new drupal site
#
# Set the following for yout site.
. drupal-env.sh

#
#Usage intstructions
if [ $# != 2 ]; then
  cat >&2 << EOH
$0 - Create drupal site settings files and symbolic links.
Usage:
  $0 sitename dbname

EOH
exit 1;
fi
site_name=$1
db_name=$2

#
#
sitedir=${drupal_base}/sites/$drupal_sitedirprefix.$site_name
#
#
#-------------
# Create the site Files
echo "Creating directory $sitedir"
mkdir $sitedir
cat >$sitedir/settings.php <<EOF
<?php
// $Id: settings.php,v 1.12.2.2 2005/04/14 18:35:19 dries Exp $
\$db_url = 'mysql://${drupal_dbuser}:${drupal_dbpassword}@localhost/$db_name';
\$base_url = '${drupal_urlprefix}/${site_name}';

\$db_prefix = '';
ini_set('arg_separator.output',     '&amp;');
ini_set('magic_quotes_runtime',     0);
ini_set('magic_quotes_sybase',      0);
ini_set('session.cache_expire',     200000);

#Dont remember logins
ini_set('session.cache_limiter',    'nocache');
ini_set('session.cookie_lifetime',  0);

ini_set('session.gc_maxlifetime',   200000);
ini_set('session.save_handler',     'user');
ini_set('session.use_only_cookies', 1);
ini_set('session.use_trans_sid',    0);
?>
EOF

#----------------------------
# Understading $sitedir contains the name of the directory that has these files,
#   Change the owner of all of the site files to www
#   Change the group of all of the site files to drupal
#   Change permissions are Group Read/Write, Owner Read/Write
#------------------------
chown -R $drupal_wwwuser:$drupal_wwwgroup $sitedir
chmod -R ug=rwx $sitedir
#----------------------------
# Understading $sitefiles dir contains the name of the directory that has these files,
#   Change the owner of all of the site specific files to www
#   Change the group of all of the site specific files to drupal
#   Change permissions are Group Read/Write, Owner Read/Write
#------------------------
sitefilesdir=${drupal_base}/files/${site_name}
echo "creating site specific files directory $sitefilesdir"
mkdir $sitefilesdir
mkdir $sitefilesdir/pictures
chown -R ${drupal_wwwuser}:${drupal_wwwgroup} $sitefilesdir
chmod -R ug=rwx $sitefilesdir
#--------------------------
# Create symbolic Link
echo "creating symbolic link $drupal_htdocs/$site_name"
ln -s $drupal_base $drupal_htdocs/$site_name
#Done
